package fr.asip.cps3.exemple.modele.exceptions;


/**
 * Classe d'exception applicative intervenant de faon inattendue lors du chargement d'une librairie
 */
public class ExceptionLibrairie extends ExceptionProgrammeExemple {
	
	private static final long serialVersionUID = 7649690258362339256L;
	
	/**
	 * Code du type d'exception
	 */
	private int typeException = -1;
	
	/**
	 * Constructeur
	 * @param typeTraitement Code du type d'exception
	 */
	public ExceptionLibrairie(int typeException) {
		super();
		this.typeException = typeException;
	}

	/**
	 * Constructeur
	 * @param typeException Code du type d'exception 
	 * @param message Intitul de l'exception
	 * @param cause Cause de l'exception
	 */
	public ExceptionLibrairie(int typeException, String message, Throwable cause) {
		super(message, cause);
		this.typeException = typeException;
	}

	/**
	 * Constructeur
	 * @param typeException Code du type d'exception 
	 * @param message Intitul de l'exception
	 */
	public ExceptionLibrairie(int typeException, String message) {
		super(message);
		this.typeException = typeException;
	}

	/**
	 * Constructeur
	 * @param typeException Code du type de traitement 
	 * @param message Intitul de l'exception
	 * @param cause Cause de l'exception
	 */
	public ExceptionLibrairie(int typeException, Throwable cause) {
		super(cause);
		this.typeException = typeException;
	}

	/**
	 * Accesseur
	 * @return le code du type de traitement
	 */
	public int getCodeException() {
		return typeException;
	}

	/**
	 * Dtermine le type d'exception
	 * @return Le type d'exception
	 */
	public String getTypeException() {
		
		switch(typeException) {
		
			case ExceptionProgrammeExemple.TYPE_LIBRAIRIE_EXCEPTION_CHARGEMENT_LIB_P11:
				return ("Erreur librairie PKCS#11");
				
			case ExceptionProgrammeExemple.TYPE_LIBRAIRIE_EXCEPTION_CHARGEMENT_LIB_TS:
				return ("Erreur librairie native des traitements spcifiques");			
					
			default:
				return "Erreur librairie";
		}
			
	}
}
